#ifndef _RC5_H_
#define _RC5_H_

typedef enum {
    RC5_ERROR,
    RC5_MID0,
    RC5_MID1,
    RC5_START0,
    RC5_START1
} RC5_STATE;

typedef struct _RC5_CONTEXT {
    unsigned long     Value;
    RC5_STATE         State;
    char              Bits;
} RC5_CONTEXT;

/*
* Returns TRUE if a signal is ready.  Caller
* MUST call Rc5_Get* to recover the value.
*/
void Rc5_Init (RC5_CONTEXT *Rc5);
char Rc5_Notify (RC5_CONTEXT *Rc5, lirc_t Data);
unsigned long Rc5_GetCode (RC5_CONTEXT *Rc5);
unsigned long Rc5_GetAddress (RC5_CONTEXT *Rc5);
unsigned long Rc5_GetCommand (RC5_CONTEXT *Rc5);
unsigned long Rc5_GetToggle  (RC5_CONTEXT *Rc5);

#endif
